/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.snmp;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.base.settings.snmp.SnmpBean;
import com.ibm.hwmca.base.settings.snmp.SnmpComNameBean;
import com.ibm.hwmca.base.settings.snmp.SnmpConstants;
import com.ibm.hwmca.base.settings.snmp.SnmpErrorIds;
import com.ibm.hwmca.base.settings.snmp.SnmpEventBean;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.snmp.SnmpTrapInterface;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.TabSubtasklet;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class SnmpTasklet
extends TabSubtasklet
implements SnmpConstants,
SnmpErrorIds {
    private static final String TRACE_MASKT = "XSNMPTKT";
    private static final String TRACE_MASKF = "XSNMPTKF";
    private static final String TRACE_MASKD = "XSNMPTKD";
    private static final String AUIML_FILE = "com.ibm.hwmca.base.settings.snmp.res.SnmpRes";
    private static final String AUIML_TAB_FILE = "com.ibm.hwmca.base.settings.snmp.res.tabpanel.SnmpTabRes";
    private static final String SETTINGS_FRAME_BEAN = "BASETOWERSETTINGSBEAN";
    private static final String SNMPD_CONF_TEMPLATE_FILE = "snmpd.conf.template";
    private static final String SNMPD_CONF_FILE = "snmpd.conf";
    private static final String SNMP_TRAPS_FILE = "snmp.traps.properties";
    private static final String PANEL_CONFIG_FILE = "snmp.panel.properties";
    private static final String DPI_DLMOD_FILE = "libdpidlmod.so";
    private BaseTower baseTower;
    private HashMap towerTrapMap;
    private HashMap savedTrapMap;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Tower;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$snmp$SnmpTrapInterface;

    public SnmpTasklet() {
        Trace.trace(TRACE_MASKT, "<> SnmpTasklet.SnmpTasklet()");
    }

    public void init() {
        Trace.trace(TRACE_MASKT, "-> SnmpTasklet.init()");
        this.baseTower = BaseTower.getBaseTower();
        this.towerTrapMap = this.getTowersSnmpTraps();
        this.savedTrapMap = this.readSnmpTrapsFile();
        Trace.trace(TRACE_MASKT, "<- SnmpTasklet.init()");
    }

    public DisplayAreaDescriptorData createTabPanel(PanelTaskletRequest request, int nextTab) {
        Trace.trace(TRACE_MASKT, "-> SnmpTasklet.createTabPanel(" + request + ", " + nextTab + ")");
        SnmpBean snmpBean = new SnmpBean();
        snmpBean.setBeanName("Tab" + nextTab);
        if (this.baseTower == null) {
            Trace.trace(TRACE_MASKT, "BASE TOWER IS NULL!");
        } else {
            snmpBean.setEnableToggle(this.baseTower.isSnmpEnabled());
            snmpBean.setAgentParmsEdit(this.baseTower.getSnmpAgentParameters());
        }
        snmpBean.initializeNamesTableData(this.readSnmpdConfFile());
        snmpBean.initializeTcpipTableData(this.savedTrapMap);
        snmpBean.setPanelAppearance(this.getPanelAppearance());
        Trace.trace(TRACE_MASKT, "<- SnmpTasklet.createTabPanel(), returning DisplayAreaDescriptorData");
        return new DisplayAreaDescriptorData(AUIML_TAB_FILE, "SnmpPanel", snmpBean, null, "Tab" + nextTab, "MountPoint");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> SnmpTasklet.service(" + request + ", " + response + ")");
        if (request.isInitialRequest()) {
            SnmpBean snmpBean = new SnmpBean();
            snmpBean.setBeanName("SnmpBean");
            if (this.baseTower == null) {
                Trace.trace(TRACE_MASKT, "BASE TOWER IS NULL!");
            } else {
                snmpBean.setEnableToggle(this.baseTower.isSnmpEnabled());
                snmpBean.setAgentParmsEdit(this.baseTower.getSnmpAgentParameters());
            }
            snmpBean.initializeNamesTableData(this.readSnmpdConfFile());
            snmpBean.initializeTcpipTableData(this.savedTrapMap);
            snmpBean.setPanelAppearance(this.getPanelAppearance());
            response.replace(AUIML_FILE, "SnmpPanel", snmpBean);
        } else {
            String panel = (String)request.getData("PANEL");
            if (panel.equals("SnmpPanel")) {
                this.serviceSnmpConfig(request, response);
            } else if (panel.equals("SnmpEventPanel")) {
                this.serviceSnmpEvent(request, response);
            } else if (panel.equals("ComNamePanel")) {
                this.serviceCommunityName(request, response);
            } else {
                response.noAction();
            }
        }
        Trace.trace(TRACE_MASKT, "<- SnmpTasklet.service()");
    }

    public String getPanelAppearance() {
        Trace.trace(TRACE_MASKT, "-> SnmpTasklet.getPanelAppearance()");
        String val = "FULL";
        try {
            FileInputStream is = new FileInputStream(BaseFileControl.getFilePath(PANEL_CONFIG_FILE) + PANEL_CONFIG_FILE);
            Properties properties = new Properties();
            properties.load(is);
            val = properties.getProperty("PANEL_CONFIG", "FULL");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpTasklet.getPanelAppearance(): returning " + val);
        return val;
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> SnmpTasklet.logException(" + throwable + ")");
        new FrameworkLog(SnmpErrorIds.LOG_INFO, 2130, throwable).log();
        Trace.trace(TRACE_MASKT, "<- SnmpTasklet.logException()");
    }

    private void serviceSnmpConfig(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> SnmpTasklet.serviceSnmpConfig(" + request + ", " + response + ")");
        String event = (String)request.getData("EVENT");
        if (event.equals("ADD_NAME")) {
            SnmpComNameBean snmpComNameBean = new SnmpComNameBean();
            snmpComNameBean.setBeanName("SnmpComNameBean");
            response.openModalChild(AUIML_FILE, "ComNamePanel", snmpComNameBean);
        } else if (event.equals("CHANGE_NAME")) {
            SnmpComNameBean snmpComNameBean = new SnmpComNameBean();
            snmpComNameBean.setBeanName("SnmpComNameBean");
            ArrayList rowData = (ArrayList)request.getData("DATA");
            snmpComNameBean.setNameEdit((String)rowData.get(0));
            snmpComNameBean.setAddressEdit((String)rowData.get(1));
            snmpComNameBean.setNetworkMaskEdit((String)rowData.get(2));
            snmpComNameBean.setAccessType((String)rowData.get(3));
            response.openModalChild(AUIML_FILE, "ComNamePanel", snmpComNameBean);
        } else if (event.equals("ADD_IP")) {
            SnmpEventBean snmpEventBean = new SnmpEventBean();
            snmpEventBean.setBeanName("SnmpEventBean");
            snmpEventBean.initializeEventsTableData(this.towerTrapMap);
            response.openModalChild(AUIML_FILE, "SnmpEventPanel", snmpEventBean);
        } else if (event.equals("CHANGE_IP")) {
            SnmpEventBean snmpEventBean = new SnmpEventBean();
            snmpEventBean.setBeanName("SnmpEventBean");
            String ipAddress = (String)request.getData("IP_ADDRESS");
            ArrayList selectedTraps = (ArrayList)request.getData("SELECTED_TRAPS");
            snmpEventBean.setTcpipAddressEdit(ipAddress);
            snmpEventBean.setSelectedEvents(selectedTraps);
            snmpEventBean.initializeEventsTableData(this.towerTrapMap);
            response.openModalChild(AUIML_FILE, "SnmpEventPanel", snmpEventBean);
        } else if (event.equals("OK") || event.equals("APPLY")) {
            ArrayList namesTable = (ArrayList)request.getData("NAMES_TABLE");
            boolean snmpEnabled = (Boolean)request.getData("SNMP_ENABLED");
            String agentParms = (String)request.getData("SNMP_PARMS");
            HashMap trapMap = (HashMap)request.getData("TRAP_MAP");
            this.writeSnmpdConfFile(namesTable);
            this.writeSnmpTrapsFile(trapMap);
            if (this.baseTower == null) {
                Trace.trace(TRACE_MASKT, "BASE TOWER IS NULL!");
            } else {
                this.baseTower.setSnmpEnabled(snmpEnabled);
                this.baseTower.setSnmpAgentParameters(agentParms);
            }
            if (event.equals("OK")) {
                PanelTaskletRequest frameRequest = new PanelTaskletRequest();
                frameRequest.setDisposed();
                if (this.isSubtasklet()) {
                    this.getParent().postRequest(SETTINGS_FRAME_BEAN, frameRequest);
                }
                response.terminate();
            } else {
                response.noAction();
            }
        } else if (event.equals("CANCEL")) {
            PanelTaskletRequest frameRequest = new PanelTaskletRequest();
            frameRequest.setDisposed();
            if (this.isSubtasklet()) {
                this.getParent().postRequest(SETTINGS_FRAME_BEAN, frameRequest);
            }
            response.terminate();
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- SnmpTasklet.serviceSnmpConfig()");
    }

    private void serviceSnmpEvent(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> SnmpTasklet.serviceSnmpEvent(" + request + ", " + response + ")");
        String event = (String)request.getData("EVENT");
        if (event.equals("OK")) {
            String ipAddress = (String)request.getData("IP_ADDRESS");
            ArrayList trapList = (ArrayList)request.getData("TRAP_LIST");
            PanelTaskletRequest selfRequest = new PanelTaskletRequest();
            selfRequest.setData("PANEL", "SnmpEventPanel");
            selfRequest.setData("EVENT", "UPDATE");
            ArrayList<Object> rowData = new ArrayList<Object>();
            rowData.add(ipAddress);
            rowData.add(trapList);
            selfRequest.setData("DATA", rowData);
            this.postRequest("SnmpBean", selfRequest);
            response.dispose();
        } else if (event.equals("CANCEL")) {
            response.dispose();
        } else if (event.equals("UPDATE")) {
            response.update("SnmpBean", request.getData("DATA"));
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- SnmpTasklet.serviceSnmpEvent()");
    }

    private void serviceCommunityName(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> SnmpTasklet.serviceCommunityName(" + request + ", " + response + ")");
        String event = (String)request.getData("EVENT");
        if (event.equals("OK")) {
            PanelTaskletRequest selfRequest = new PanelTaskletRequest();
            selfRequest.setData("PANEL", "ComNamePanel");
            selfRequest.setData("EVENT", "UPDATE");
            selfRequest.setData("DATA", request.getData("DATA"));
            this.postRequest("SnmpBean", selfRequest);
            response.dispose();
        } else if (event.equals("CANCEL")) {
            response.dispose();
        } else if (event.equals("UPDATE")) {
            response.update("SnmpBean", request.getData("DATA"));
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- SnmpTasklet.serviceCommunityName()");
    }

    private HashMap getTowersSnmpTraps() {
        Trace.trace(TRACE_MASKT, "-> SnmpTasklet.getTowersSnmpTraps()");
        HashMap result = new HashMap();
        try {
            ClassId classId = new ClassId(class$com$ibm$hwmca$fw$managed$Tower == null ? (class$com$ibm$hwmca$fw$managed$Tower = SnmpTasklet.class$("com.ibm.hwmca.fw.managed.Tower")) : class$com$ibm$hwmca$fw$managed$Tower);
            ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
            Iterator iterator = mom.getInventory(classId).iterator();
            while (iterator.hasNext()) {
                Tower tower = (Tower)iterator.next();
                SnmpTrapInterface snmpTrapInterface = (SnmpTrapInterface)tower.getInterfaceImpl(class$com$ibm$hwmca$fw$snmp$SnmpTrapInterface == null ? SnmpTasklet.class$("com.ibm.hwmca.fw.snmp.SnmpTrapInterface") : class$com$ibm$hwmca$fw$snmp$SnmpTrapInterface);
                if (snmpTrapInterface == null) continue;
                Trace.trace(TRACE_MASKF, "SnmpTasklet.getSnmpTraps(): " + tower.getName() + " implements the SNMP trap interface.");
                Map traps = snmpTrapInterface.getSnmpTraps();
                result.putAll(traps);
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpTasklet.getTowersSnmpTraps()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap readSnmpTrapsFile() {
        Trace.trace(TRACE_MASKT, "-> SnmpTasklet.readSnmpTrapsFile()");
        HashMap result = new HashMap();
        FileInputStream fileInputStream = null;
        try {
            File snmpTrapsFile = new File(BaseFileControl.getFilePath(SNMP_TRAPS_FILE) + SNMP_TRAPS_FILE);
            if (snmpTrapsFile.exists() && snmpTrapsFile.canRead()) {
                fileInputStream = new FileInputStream(snmpTrapsFile);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String address = (String)enumeration.nextElement();
                    String trapString = (String)properties.get(address);
                    ArrayList<String> trapsList = new ArrayList<String>();
                    StringTokenizer tokenizer = new StringTokenizer(trapString, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String trap = tokenizer.nextToken();
                        trapsList.add(trap);
                    }
                    if (trapsList.size() <= 0) continue;
                    result.put(address, trapsList);
                }
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            new FrameworkLog(SnmpErrorIds.LOG_INFO, 2130, exc).log();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKF, exc);
                    new FrameworkLog(SnmpErrorIds.LOG_INFO, 2130, exc).log();
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- SnmpTasklet.readSnmpTrapsFile()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSnmpTrapsFile(Map map) {
        Trace.trace(TRACE_MASKT, "-> SnmpTasklet.writeSnmpTrapsFile(" + map + ")");
        FileOutputStream fileOutputStream = null;
        try {
            File snmpTrapsFile = new File(BaseFileControl.getFilePath(SNMP_TRAPS_FILE) + SNMP_TRAPS_FILE);
            fileOutputStream = new FileOutputStream(snmpTrapsFile);
            Properties properties = new Properties();
            Set keys = map.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String address = (String)iterator.next();
                ArrayList trapList = (ArrayList)map.get(address);
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < trapList.size()) {
                    String trap = (String)trapList.get(i);
                    if (i == trapList.size() - 1) {
                        buffer.append(trap);
                    } else {
                        buffer.append(trap + ",");
                    }
                    if (buffer.length() > 0) {
                        properties.setProperty(address, buffer.toString());
                    }
                    ++i;
                }
            }
            properties.store(fileOutputStream, null);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            new FrameworkLog(SnmpErrorIds.LOG_INFO, 2130, exc).log();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
                new FrameworkLog(SnmpErrorIds.LOG_INFO, 2130, exc).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- SnmpTasklet.writeSnmpTrapsFile()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ArrayList readSnmpdConfFile() {
        Trace.trace(TRACE_MASKT, "-> SnmpTasklet.readSnmpdConfFile()");
        ArrayList snmpdData = new ArrayList();
        BufferedReader bufferedReader = null;
        try {
            File snmpdConfFile = new File(BaseFileControl.getFilePath(SNMPD_CONF_FILE) + SNMPD_CONF_FILE);
            if (snmpdConfFile.exists() && snmpdConfFile.canRead()) {
                String line;
                ArrayList<String> communityNames = new ArrayList<String>();
                ArrayList<String> hostAddresses = new ArrayList<String>();
                ArrayList<String> networkMasks = new ArrayList<String>();
                ArrayList<String> accessTypes = new ArrayList<String>();
                bufferedReader = new BufferedReader(new FileReader(snmpdConfFile));
                while ((line = bufferedReader.readLine()) != null) {
                    void var8_11;
                    if (!var8_11.startsWith("com2sec")) continue;
                    StringTokenizer tokenizer = new StringTokenizer((String)var8_11);
                    tokenizer.nextToken();
                    String securityName = tokenizer.nextToken();
                    accessTypes.add(securityName);
                    String source = tokenizer.nextToken();
                    int slash = source.indexOf("/");
                    String address = source.substring(0, slash);
                    hostAddresses.add(address);
                    String networkMask = source.substring(slash + 1);
                    networkMasks.add(networkMask);
                    String communityName = tokenizer.nextToken();
                    communityNames.add(communityName);
                }
                snmpdData.add(communityNames);
                snmpdData.add(hostAddresses);
                snmpdData.add(networkMasks);
                snmpdData.add(accessTypes);
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            new FrameworkLog(SnmpErrorIds.LOG_INFO, 2130, exc).log();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKF, exc);
                    new FrameworkLog(SnmpErrorIds.LOG_INFO, 2130, exc).log();
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- SnmpTasklet.readSnmpdConfFile()");
        return snmpdData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void writeSnmpdConfFile(ArrayList tableData) {
        Trace.trace(TRACE_MASKT, "-> SnmpTasklet.writeSnmpdConfFile(" + tableData + ")");
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            File templateFile = new File(BaseFileControl.getFilePath(SNMPD_CONF_TEMPLATE_FILE) + SNMPD_CONF_TEMPLATE_FILE);
            bufferedReader = new BufferedReader(new FileReader(templateFile));
            File snmpdConfFile = new File(BaseFileControl.getFilePath(SNMPD_CONF_FILE) + SNMPD_CONF_FILE);
            bufferedWriter = new BufferedWriter(new FileWriter(snmpdConfFile));
            if (templateFile.exists() && templateFile.canRead()) {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    void var6_9;
                    bufferedWriter.write((String)var6_9 + "\n");
                }
                int i = 0;
                while (i < tableData.size()) {
                    ArrayList tableRow = (ArrayList)tableData.get(i);
                    String name = (String)tableRow.get(0);
                    String address = (String)tableRow.get(1);
                    String networkMask = (String)tableRow.get(2);
                    String accessType = (String)tableRow.get(3);
                    if (networkMask.equals("255.255.255.255")) {
                        bufferedWriter.write("com2sec  " + accessType + "  " + address + "/" + "  " + name + "\n");
                    } else {
                        bufferedWriter.write("com2sec  " + accessType + "  " + address + "/" + networkMask + "  " + name + "\n");
                    }
                    ++i;
                }
                String dlmodLoc = BaseFileControl.getFilePath(DPI_DLMOD_FILE) + DPI_DLMOD_FILE;
                bufferedWriter.write("\ndlmod hmc_dpi " + dlmodLoc + "\n");
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            new FrameworkLog(SnmpErrorIds.LOG_INFO, 2130, exc).log();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
                new FrameworkLog(SnmpErrorIds.LOG_INFO, 2130, exc).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- SnmpTasklet.writeSnmpdConfFile()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

